/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.forge.datagen;

import corgitaco.enhancedcelestials.EnhancedCelestials;
import corgitaco.enhancedcelestials.api.EnhancedCelestialsRegistry;
import corgitaco.enhancedcelestials.api.lunarevent.DefaultLunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.DefaultLunarEvents;
import corgitaco.enhancedcelestials.api.lunarevent.LunarDimensionSettings;
import corgitaco.enhancedcelestials.api.lunarevent.LunarEvent;
import corgitaco.enhancedcelestials.forge.datagen.providers.ECItemTagsProvider;
import corgitaco.enhancedcelestials.forge.datagen.providers.ECLunarEventTagsProvider;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.ECStructures;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="enhancedcelestials")
public class ECDataGen {
    private static RegistrySetBuilder makeBuilder(boolean useMinecraftNameSpace) {
        ResourceKey lunarEventKey = useMinecraftNameSpace ? ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("lunar/event")) : EnhancedCelestialsRegistry.LUNAR_EVENT_KEY;
        ResourceKey dimensionSettingsKey = useMinecraftNameSpace ? ResourceKey.m_135788_((ResourceLocation)new ResourceLocation("lunar/dimension_settings")) : EnhancedCelestialsRegistry.LUNAR_DIMENSION_SETTINGS_KEY;
        return new RegistrySetBuilder().m_254916_(lunarEventKey, pContext -> DefaultLunarEvents.LUNAR_EVENT_FACTORIES.forEach((lunarEventResourceKey, factory) -> pContext.m_255272_(ResourceKey.m_135785_((ResourceKey)lunarEventKey, (ResourceLocation)lunarEventResourceKey.m_135782_()), (Object)factory.generate((BootstapContext<LunarEvent>)pContext)))).m_254916_(dimensionSettingsKey, pContext -> DefaultLunarDimensionSettings.LUNAR_DIMENSION_SETTINGS_FACTORIES.forEach((lunarEventResourceKey, factory) -> pContext.m_255272_(ResourceKey.m_135785_((ResourceKey)dimensionSettingsKey, (ResourceLocation)lunarEventResourceKey.m_135782_()), (Object)factory.generate((BootstapContext<LunarDimensionSettings>)pContext)))).m_254916_(Registries.f_256944_, pContext -> {});
    }

    @SubscribeEvent
    static void onDatagen(GatherDataEvent event) {
        EnhancedCelestials.commonSetup();
        CompletionStage providerForge = event.getLookupProvider().thenApply(provider -> ECDataGen.makeBuilder(false).m_254929_((RegistryAccess)RegistryAccess.m_206165_((Registry)BuiltInRegistries.f_257047_), provider));
        DataGenerator gen = event.getGenerator();
        gen.addProvider(event.includeServer(), (DataProvider)new ECLunarEventTagsProvider(gen.getPackOutput(), false, EnhancedCelestialsRegistry.LUNAR_EVENT_KEY, (CompletableFuture<HolderLookup.Provider>)providerForge, "enhancedcelestials", event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new ECItemTagsProvider(gen.getPackOutput(), (CompletableFuture<HolderLookup.Provider>)providerForge, CompletableFuture.completedFuture(blockTagKey -> Optional.empty()), "enhancedcelestials", event.getExistingFileHelper()));
        gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(gen.getPackOutput(), event.getLookupProvider(), ECDataGen.makeBuilder(false), Set.of("enhancedcelestials", "minecraft")));
    }

    private static /* synthetic */ void lambda$makeBuilder$4(BootstapContext pContext, ResourceKey resourceKey, ECStructures.StructureFactory factory) {
        pContext.m_255272_(resourceKey, (Object)factory.generate((BootstapContext<Structure>)pContext));
    }
}

